/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal;

import com.aptana.terminal.Messages;
import com.aptana.terminal.TerminalPlugin;
import com.aptana.terminal.editor.TerminalEditorInput;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class Utils {
    private Utils() {
    }

    public static IEditorPart openTerminalEditor(String editorId, boolean activate) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return Utils.openTerminalEditor(window, editorId, activate);
    }

    public static IEditorPart openTerminalEditor(IWorkbenchWindow window, String editorId, boolean activate) {
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return null;
            }
            try {
                return page.openEditor((IEditorInput)new TerminalEditorInput(), editorId, activate, 1);
            }
            catch (PartInitException e) {
                String message = MessageFormat.format(Messages.Utils_Unable_To_Open_Editor, editorId);
                TerminalPlugin.log(message, e);
            }
        }
        return null;
    }

    public static String encodeString(String text) {
        StringBuffer buffer = new StringBuffer();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= '\u0000' && c < ' ' || '\u0080' <= c) {
                String hex = String.format("%1$02X", c);
                buffer.append("\\x").append(hex);
            } else {
                buffer.append(c);
            }
            ++n2;
        }
        return buffer.toString();
    }

    public static void runInDisplayThread(Runnable runnable) {
        if (Display.findDisplay((Thread)Thread.currentThread()) != null) {
            runnable.run();
        } else if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(runnable);
        }
    }
}

